#!/bin/bash
#
# Script used as demo during the workshop
# "Tools, Workflows and Resources"
# 06 Oct. 2022, HSRW Germany


# Used the next line to set the list of directories
DIRECTORIES="~/ ~/Documents ~/Desktop"
# Uncommend the next line if you are using a external file
# for track the list of directories
# DIRECTORIES=$(cat ~/EXTERNAL-FILE | tr "\n" " ")
# Note about the external file
#       Format of the file:
#           ~/ 
#           ~/Documents
#           ~/Desktop
#       One directory per line

if [[ $# -eq 1 ]]; then
    SELECTED=$1 && [[ "$SELECTED" == '.' ]] && SELECTED="$PWD"
else
    SELECTED=$(find $DIRECTORIES -mindepth 1 -maxdepth 1 -type d | fzf)
fi

if [[ -z $SELECTED ]]; then
    exit 0
fi

SELECTED_NAME=$(basename "$SELECTED" | tr . _)
SELECTED_NAME=${SELECTED_NAME:0:8}

if [[ -n $TMUX ]]; then
    # inside tmux
    tmux switch-client -t "$SELECTED_NAME" || \
    tmux new-session -ds "$SELECTED_NAME" -c "$SELECTED" && \
    tmux switch-client -t "$SELECTED_NAME"
elif [[ -z $TMUX ]]; then
    # outside tmux
    tmux new-session -s "$SELECTED_NAME" -c "$SELECTED" || \
    tmux attach -t "$SELECTED_NAME"
fi
