#!/bin/bash
#
# Script used as demo during the workshop
# "Tools, Workflows and Resources"
# 06 Oct. 2022, HSRW Germany

ARG_TAG="-tag"
ARG_HELP="-h"
COLOR_OFF="\033[0m"
COLOR_RED="\033[0;31m"

sudo apt-get update

help(){
    cat << EOF
NAME
       Shell script to install my sofware

SYNOPSIS
       bash automation2.sh [OPTIONS <string>] 

OPTIONS
       -tag     Install software base on tags
                - core: install core Packages
                - tools: install tools
                - software: install all

       -h       Show help
EOF
}

install_core(){
    echo "Install my Core System Packages"
    apt-get install -y \
        build-essential \
        cmake \
        pkg-config \
        libpthread-stubs0-dev

}

install_tools(){
    echo "Install my tools"
    apt-get install -y \
        curl \
        htop \
        python3-pip
}

install_with_tag(){
    if [[ $1 = $ARG_TAG && $2 = "core" ]]; then
        install_core
    elif [[ $1 = $ARG_TAG ]] && [[ $2 = "tools" ]]; then
        install_tools
    elif [[ $1 = $ARG_TAG ]] && [[ $2 = "software" ]]; then
        install_core
        install_tools
    elif [[ $1 = $ARG_HELP ]]; then
        echo "HELP"
        help
    else
        echo -e "${COLOR_RED}ERROR: Invalid tag${COLOR_OFF}"
        help
    fi
}


if [ $# -eq 0 ]
then
    install_core
    install_tools
else
    if [ $# -eq 2 ]; then
        install_with_tag $1 $2
    else
        echo -e "${COLOR_RED}ERROR: Invalid syntax${COLOR_OFF}"
        help
    fi
fi
